/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCL;
import com.ibm.hwmca.base.updates.MCLDataFileFilter;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.updates.NewMCLDataFileFilter;
import com.ibm.hwmca.base.updates.RsfRequestCompleted;
import com.ibm.hwmca.base.updates.RsfResultsHandler;
import com.ibm.hwmca.base.updates.SpecificRequestNotPossibleException;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfDisabledException;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import com.ibm.hwmca.xfw.rsf.MicrocodeFunctionRequestBody;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BaseUpdater
extends Updater
implements MCLErrorIds,
RsfRequestCompleted {
    private static final String TRACE_MASKT = "XMCLB  T";
    private static final String TRACE_MASKF = "XMCLB  F";
    private static final String TRACE_MASKD = "XMCLB  D";
    private static final int XMCL_BEYOND_MAXIMUM_LEVEL = 10000;
    private static final int XMCL_DOING_IMPORT = 1;
    private static final int XMCL_DOING_EXPORT = 2;
    private static final int XMCL_DOING_RECALL = 3;
    private static final int XMCL_TO_STAGING_ONLY = 4;
    private static final String ON_HOLD_FILES = "IQZMHOLD.DAT";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    private static String XMCL_MEDIA_REPOSITORY = "/mcl/";
    public static final String ATTRIBUTE_DURATION = "duration";
    private String distributionStagingArea;
    private String updateStagingArea;
    private String bundleName;
    private File exportMountPoint;
    private RsfResult rsfResult;

    public BaseUpdater(UpdatesOwner owner) {
        super(owner);
        try {
            this.distributionStagingArea = BaseFileControl.getFilePath("tmp");
            this.updateStagingArea = BaseFileControl.getFilePath("iqzmcf.mcf");
        }
        catch (HException hexc) {
            this.logError("Unable to access staging area", (short)-3954, hexc);
        }
        this.bundleName = "com/ibm/hwmca/base/res/message";
        Trace.trace(TRACE_MASKT, "<> BaseUpdater()");
    }

    public void cancel() {
    }

    private void deleteUpdatesFromStagingArea(String stagingAreaPath) {
        String[] newFiles;
        Trace.trace(TRACE_MASKT, "-> deleteUpdatesFromStagingArea()");
        File stagingArea = new File(stagingAreaPath);
        String[] files = stagingArea.list(new MCLDataFileFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                Trace.trace(TRACE_MASKD, "MCL data file " + files[i] + " has been found.");
                File fileToDelete = new File(stagingAreaPath + files[i]);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL data file " + stagingAreaPath + files[i] + " has been deleted.");
                int dotPosition = files[i].indexOf(".");
                String ecNumber = files[i].substring(1, dotPosition);
                String coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                fileToDelete = new File(stagingAreaPath + coverLetter);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL cover letter " + stagingAreaPath + coverLetter + " has been deleted.");
            }
        }
        if ((newFiles = stagingArea.list(new NewMCLDataFileFilter())) != null) {
            for (int i = 0; i < newFiles.length; ++i) {
                Trace.trace(TRACE_MASKD, "MCL data file " + newFiles[i] + " has been found.");
                File fileToDelete = new File(stagingAreaPath + newFiles[i]);
                fileToDelete.delete();
                Trace.trace(TRACE_MASKD, "MCL data file " + stagingAreaPath + newFiles[i] + " has been deleted.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- deleteUpdatesFromStagingArea()");
    }

    public void downloadRemoteUpdatesToStagingArea(Collection levels) {
        Trace.trace(TRACE_MASKT, "-> downloadRemoteUpdatesToStagingArea()");
        ArrayList<UpdateRange> ranges = new ArrayList<UpdateRange>();
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            String ecNumber = nextStream.getUpdateableComponentECNumber();
            int lastLevelToDo = nextStream.getLevel();
            int firstLevelToDo = nextStream.getLevel() + 1;
            ranges.add(new UpdateRange(ecNumber, firstLevelToDo, -1));
        }
        if (ranges.size() > 0) {
            final ArrayList<UpdateRange> importRanges = ranges;
            int function = 4;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    BaseUpdater.this.importRemoteUpdatesSynchronously(importRanges, 4);
                }
            }, "Asynchronous importRemoteUpdates recall operation");
            thread.setDaemon(true);
            thread.start();
        }
        Trace.trace(TRACE_MASKT, "<- downloadRemoteUpdatesToStagingArea()");
    }

    public void exportUpdatesToMedia(File mountPoint, int mediaType, Collection levels) {
        Trace.trace(TRACE_MASKT, "-> exportUpdatesToMedia()");
        this.exportMountPoint = mountPoint;
        this.importRemoteUpdateRanges(levels, true);
        Trace.trace(TRACE_MASKT, "<- exportUpdatesToMedia()");
    }

    public Collection getLatestUpdateLevelsFromMedia(File mountPoint, int mediaType, Collection ecNumbers) {
        Trace.trace(TRACE_MASKT, "-> getLatestUpdateLevelsFromMedia()");
        ArrayList<UpdateLevel> latestLevels = new ArrayList<UpdateLevel>();
        String mediaStagingArea = mountPoint + XMCL_MEDIA_REPOSITORY;
        File stagingArea = new File(mediaStagingArea);
        Iterator counterOfECs = ecNumbers.iterator();
        while (counterOfECs.hasNext()) {
            int dotPosition;
            int i;
            String ecNumber = (String)counterOfECs.next();
            String[] files = stagingArea.list(new MCLDataFileFilter(ecNumber, 1, 10000));
            String[] newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber, 1, 10000));
            if (files == null && newFiles == null) continue;
            int numberOfPossibleLevels = 0;
            if (files != null) {
                numberOfPossibleLevels += files.length;
            }
            if (newFiles != null) {
                numberOfPossibleLevels += newFiles.length;
            }
            int[] levelsFound = new int[numberOfPossibleLevels];
            int numberOfLevelsFound = 0;
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    Trace.trace(TRACE_MASKF, "MCL data file " + files[i] + " has been found.");
                    dotPosition = files[i].indexOf(".");
                    String coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                    Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                    File coverLetterFile = new File(mediaStagingArea + coverLetter);
                    if (!coverLetterFile.exists()) continue;
                    int level = Integer.parseInt(files[i].substring(dotPosition + 1), 10);
                    Trace.trace(TRACE_MASKD, "level found = " + level);
                    boolean inserted = false;
                    for (int indexToAdd = 0; !inserted && indexToAdd < numberOfLevelsFound; ++indexToAdd) {
                        int nextLevel = levelsFound[indexToAdd];
                        if (level >= nextLevel) continue;
                        Trace.trace(TRACE_MASKD, "Adding to the list at index = " + indexToAdd);
                        for (int idx = numberOfLevelsFound - 1; idx >= indexToAdd; --idx) {
                            levelsFound[idx + 1] = levelsFound[idx];
                        }
                        levelsFound[indexToAdd] = level;
                        ++numberOfLevelsFound;
                        inserted = true;
                    }
                    if (inserted) continue;
                    Trace.trace(TRACE_MASKD, "Adding the level at the end of the list.");
                    levelsFound[numberOfLevelsFound] = level;
                    ++numberOfLevelsFound;
                }
            }
            if (newFiles != null) {
                for (i = 0; i < newFiles.length; ++i) {
                    Trace.trace(TRACE_MASKF, "MCL data file " + newFiles[i] + " has been found.");
                    dotPosition = newFiles[i].indexOf(".");
                    int nextDotPosition = newFiles[i].indexOf(".", dotPosition + 1);
                    int level = Integer.parseInt(newFiles[i].substring(dotPosition + 1, nextDotPosition), 10);
                    Trace.trace(TRACE_MASKD, "level found = " + level);
                    boolean inserted = false;
                    for (int indexToAdd = 0; !inserted && indexToAdd < numberOfLevelsFound; ++indexToAdd) {
                        int nextLevel = levelsFound[indexToAdd];
                        if (level >= nextLevel) continue;
                        Trace.trace(TRACE_MASKD, "Adding to the list at index = " + indexToAdd);
                        for (int idx = numberOfLevelsFound - 1; idx >= indexToAdd; --idx) {
                            levelsFound[idx + 1] = levelsFound[idx];
                        }
                        levelsFound[indexToAdd] = level;
                        ++numberOfLevelsFound;
                        inserted = true;
                    }
                    if (inserted) continue;
                    Trace.trace(TRACE_MASKD, "Adding the level at the end of the list.");
                    levelsFound[numberOfLevelsFound] = level;
                    ++numberOfLevelsFound;
                }
            }
            if (numberOfLevelsFound == 0) continue;
            int lastContinuousLevel = levelsFound[0];
            boolean done = false;
            for (int currentIndex = 1; !done && currentIndex < numberOfLevelsFound; ++currentIndex) {
                int nextLevel = levelsFound[currentIndex];
                if (nextLevel == lastContinuousLevel + 1) {
                    nextLevel = lastContinuousLevel;
                    continue;
                }
                done = true;
            }
            Trace.trace(TRACE_MASKF, "Level " + lastContinuousLevel + " is the highest found on media for EC " + ecNumber);
            UpdateLevel latestLevelOfEC = new UpdateLevel(ecNumber, lastContinuousLevel);
            latestLevels.add(latestLevelOfEC);
        }
        Trace.trace(TRACE_MASKT, "<- getLatestUpdateLevelsFromMedia()");
        return latestLevels;
    }

    public void importAllRemoteUnstagedUpdates(boolean forExporting) {
        Trace.trace(TRACE_MASKT, "-> importAllRemoteUnstagedUpdates()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logError("Failed getting EC streams " + hexc, (short)-3903, hexc);
        }
        ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
        ListIterator counterOfStreams = streams.listIterator();
        while (counterOfStreams.hasNext()) {
            ECStream nextEc = (ECStream)counterOfStreams.next();
            UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
            levelsToProcess.add(nextLevel);
        }
        if (levelsToProcess.size() > 0) {
            this.importRemoteUpdatesThroughLevel(levelsToProcess, forExporting);
        }
        Trace.trace(TRACE_MASKT, "<- importAllRemoteUnstagedUpdates()");
    }

    public void importRemoteUpdatesThroughLevel(Collection levels, boolean forExporting) {
        Trace.trace(TRACE_MASKT, "-> importRemoteUpdatesThroughLevel()");
        ArrayList<UpdateRange> ranges = new ArrayList<UpdateRange>();
        UpdateManager manager = UpdateManager.getUpdateManager();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        String logInfo = null;
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            String ecNumber = nextStream.getUpdateableComponentECNumber();
            ECStream nextEc = (ECStream)manager.getComponentByECNumber(ecNumber);
            int firstLevelToDo = nextEc.getStagedLevel() + 1;
            if (firstLevelToDo == 0) {
                firstLevelToDo = 1;
            }
            ranges.add(new UpdateRange(ecNumber, firstLevelToDo, lastLevelToDo));
            logInfo = null == logInfo ? ecNumber + "." + nf.format(firstLevelToDo) : logInfo + " " + ecNumber + "." + nf.format(firstLevelToDo);
            if (-1 == lastLevelToDo) {
                logInfo = logInfo + "-ALL";
                continue;
            }
            logInfo = logInfo + "-" + nf.format(lastLevelToDo);
        }
        if (ranges.size() > 0) {
            if (!forExporting) {
                String[] substText = new String[]{logInfo};
                FrameworkEventText eventText = new FrameworkEventText(567, substText);
                new SystemEventLog(eventText, "MMCRET_IBMSS").log();
                new E4EventLog(eventText, "MMCRET_IBMSS").log();
            }
            this.importRemoteUpdateRanges(ranges, forExporting);
        }
        Trace.trace(TRACE_MASKT, "<- importRemoteUpdatesThroughLevel()");
    }

    public void importRemoteUpdateRanges(Collection ranges, boolean forExporting) {
        Trace.trace(TRACE_MASKT, "<> importRemoteUpdateRanges()");
        final Collection importLevels = ranges;
        final int function = forExporting ? 2 : 1;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                BaseUpdater.this.importRemoteUpdatesSynchronously(importLevels, function);
            }
        }, "Asynchronous importRemoteUpdates operation");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void importRemoteUpdatesSynchronously(Collection ranges, int function) {
        block72: {
            ArrayList<UpdateRange> exportCollections;
            ArrayList<MCL> importCollections;
            boolean failed;
            block69: {
                String[] files;
                String ecNumber;
                boolean done;
                block75: {
                    BufferedInputStream instream;
                    block68: {
                        block74: {
                            block73: {
                                String stagingAreaPath;
                                Trace.trace(TRACE_MASKT, "-> importRemoteUpdatesSynchronously()");
                                failed = false;
                                done = false;
                                importCollections = new ArrayList<MCL>();
                                exportCollections = new ArrayList<UpdateRange>();
                                MicrocodeFunctionRequestBody request = new MicrocodeFunctionRequestBody();
                                request.initializeMachineInformation();
                                request.initializeUpdateList();
                                if (function == 3) {
                                    request.setFunctionType('1');
                                } else {
                                    request.setFunctionType('0');
                                }
                                Collection rsfRanges = MicrocodeFunctionRequestBody.convertUpdateRangeCollection(ranges);
                                request.setUpdateRangeList(rsfRanges);
                                if (function == 2) {
                                    stagingAreaPath = this.distributionStagingArea;
                                    this.deleteUpdatesFromStagingArea(stagingAreaPath);
                                } else {
                                    stagingAreaPath = this.updateStagingArea;
                                }
                                Trace.trace(TRACE_MASKD, "Asking RETAIN to go to a directory of [" + stagingAreaPath + "].");
                                request.setStagingPathname(stagingAreaPath);
                                RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
                                String id = " ";
                                int newCount = 0;
                                try {
                                    RsfResultsHandler handler = new RsfResultsHandler();
                                    RsfRequest rsfRequest = rsf.newRequestInstance(request, handler.getClass().getName(), new LocalizableText(this.bundleName, "MCL0041"));
                                    id = rsfRequest.getId();
                                    RsfResultsHandler.register(id, this);
                                    BaseUpdater baseUpdater = this;
                                    synchronized (baseUpdater) {
                                        rsfRequest.submit();
                                        int waitTime = 0;
                                        int oldCount = -1;
                                        while (!done && waitTime < 60) {
                                            try {
                                                block71: {
                                                    block70: {
                                                        this.wait(60000L);
                                                        if (rsfRequest.getState() == 5) break block70;
                                                        if (rsfRequest.getState() != 4) break block71;
                                                    }
                                                    done = true;
                                                    continue;
                                                }
                                                ++waitTime;
                                                List updates = this.queryStagingAreaForUpdates(stagingAreaPath);
                                                newCount = updates.size();
                                                if (newCount == oldCount) continue;
                                                String key = "MCL0038";
                                                Object[] parms = new String[]{String.valueOf(updates.size())};
                                                MessageText message = new MessageText(this.bundleName, key, parms);
                                                UpdaterEvent event = new UpdaterEvent(this);
                                                event.setMessage(message);
                                                super.fireOperationProgressing(event);
                                                waitTime = 0;
                                            }
                                            catch (InterruptedException e) {
                                                if (rsfRequest.getState() != 5) {
                                                    if (rsfRequest.getState() != 4) continue;
                                                }
                                                done = true;
                                            }
                                        }
                                    }
                                }
                                catch (RsfDisabledException rde) {
                                    this.logAndFireError("RSF disabled " + rde, (short)-3882, rde);
                                    RsfResultsHandler.deregister(id);
                                    failed = true;
                                }
                                catch (Exception e) {
                                    this.logAndFireError("Error getting MCLs from retain " + e, (short)-3889, e);
                                    RsfResultsHandler.deregister(id);
                                    failed = true;
                                }
                                if (done) {
                                    int rsfReturnCode = this.rsfResult.getStatusCode();
                                    int rsfReasonCode = this.rsfResult.getReasonCode();
                                    Trace.trace(TRACE_MASKF, "rsfReturnCode = " + rsfReturnCode);
                                    if (rsfReturnCode != 1 && rsfReasonCode != 100) {
                                        failed = true;
                                        Object[] parms = new LocalizableText[1];
                                        if (rsfReturnCode == 5) {
                                            parms[0] = new MessageText(this.bundleName, "MCL0015");
                                            Trace.trace(TRACE_MASKF, parms[0]);
                                        } else {
                                            parms[0] = this.rsfResult.getStatusMessage();
                                            Trace.trace(TRACE_MASKF, "Retrieve from retain failed due to +" + this.rsfResult.getStatusMessage());
                                        }
                                        String key = "MCL0040";
                                        MessageText message = new MessageText(this.bundleName, key, parms);
                                        UpdaterEvent event = new UpdaterEvent(this);
                                        event.setMessage(message);
                                        event.setCompletionStatus(2);
                                        super.fireOperationCompleted(event);
                                    }
                                } else if (newCount > 0 && function != 3) {
                                    RsfResultsHandler.deregister(id);
                                    done = true;
                                }
                                if (failed) break block72;
                                if (done) break block73;
                                this.logAndFireError("Retain timed out", (short)-3890);
                                RsfResultsHandler.deregister(id);
                                failed = true;
                                break block69;
                            }
                            if (function != 2) break block74;
                            String exportDirectory = this.exportMountPoint + XMCL_MEDIA_REPOSITORY;
                            Trace.trace(TRACE_MASKD, "exportDirectory=[" + exportDirectory + "].");
                            File directoryAsFile = new File(exportDirectory);
                            if (!directoryAsFile.exists()) {
                                boolean built = directoryAsFile.mkdir();
                                Trace.trace(TRACE_MASKF, (built ? "Created" : "Failed to create") + " " + exportDirectory);
                                if (!built) {
                                    String key = "MCL0054";
                                    Object[] parms = new String[]{"Unable to create fix repository on media."};
                                    MessageText message = new MessageText(this.bundleName, key, parms);
                                    UpdaterEvent event = new UpdaterEvent(this);
                                    event.setMessage(message);
                                    super.fireOperationCompleted(event);
                                    done = true;
                                    failed = true;
                                }
                            }
                            File stagingArea = new File(this.distributionStagingArea);
                            Iterator counterOfRanges = ranges.iterator();
                            while (counterOfRanges.hasNext() && !failed) {
                                String[] newFiles;
                                UpdateRange nextRange = (UpdateRange)counterOfRanges.next();
                                ecNumber = nextRange.getUpdateableComponentECNumber();
                                int firstLevel = nextRange.getFirstLevel();
                                int lastLevel = nextRange.getLastLevel();
                                int lastWrittenLevel = -1;
                                if (lastLevel == -1) {
                                    lastLevel = 10000;
                                }
                                if ((files = stagingArea.list(new MCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                                    done = false;
                                    for (int i = 0; i < files.length && !done; ++i) {
                                        Trace.trace(TRACE_MASKF, "MCL data file " + files[i] + " has been found.");
                                        int dotPosition = files[i].indexOf(".");
                                        String coverLetter = "C" + ecNumber + "0" + files[i].substring(dotPosition);
                                        Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                                        File coverLetterFile = new File(this.distributionStagingArea + coverLetter);
                                        if (!coverLetterFile.exists()) continue;
                                        try {
                                            UpdateUtilities.copyFile(this.distributionStagingArea + coverLetter, exportDirectory + coverLetter.toUpperCase());
                                            UpdateUtilities.copyFile(this.distributionStagingArea + files[i], exportDirectory + files[i].toUpperCase());
                                            lastWrittenLevel = Integer.parseInt(files[i].substring(dotPosition + 1), 10);
                                            continue;
                                        }
                                        catch (IOException hexc) {
                                            String key = "MCL0054";
                                            Object[] parms = new String[]{String.valueOf(hexc)};
                                            MessageText message = new MessageText(this.bundleName, key, parms);
                                            UpdaterEvent event = new UpdaterEvent(this);
                                            event.setMessage(message);
                                            super.fireOperationCompleted(event);
                                        }
                                    }
                                }
                                if ((newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber, firstLevel, lastLevel))) != null) {
                                    done = false;
                                    for (int i = 0; i < newFiles.length && !done; ++i) {
                                        Trace.trace(TRACE_MASKF, "MCL data file " + newFiles[i] + " has been found.");
                                        try {
                                            UpdateUtilities.copyFile(this.distributionStagingArea + newFiles[i], exportDirectory + newFiles[i]);
                                            int dotPosition1 = newFiles[i].indexOf(".");
                                            int dotPosition2 = newFiles[i].indexOf(".", dotPosition1 + 1);
                                            if (dotPosition2 == -1) continue;
                                            String idString = newFiles[i].substring(dotPosition1 + 1, dotPosition2);
                                            lastWrittenLevel = Integer.parseInt(idString, 10);
                                            continue;
                                        }
                                        catch (IOException hexc) {
                                            String key = "MCL0054";
                                            Object[] parms = new String[]{String.valueOf(hexc)};
                                            MessageText message = new MessageText(this.bundleName, key, parms);
                                            UpdaterEvent event = new UpdaterEvent(this);
                                            event.setMessage(message);
                                            super.fireOperationCompleted(event);
                                            done = true;
                                            failed = true;
                                        }
                                    }
                                }
                                if (lastWrittenLevel == -1) continue;
                                UpdateRange writtenRange = new UpdateRange(ecNumber, firstLevel, lastWrittenLevel);
                                exportCollections.add(writtenRange);
                            }
                            break block69;
                        }
                        if (function != 3) break block75;
                        String onholdFile = " ";
                        instream = null;
                        UpdateManager manager = UpdateManager.getUpdateManager();
                        String onHoldPath = BaseFileControl.getFilePath(ON_HOLD_FILES);
                        String onHoldFile = onHoldPath + ON_HOLD_FILES;
                        instream = new BufferedInputStream(new FileInputStream(onHoldFile));
                        byte[] byteHoldCount = new byte[2];
                        this.readFully(instream, byteHoldCount);
                        int holdCount = BinaryNumber.toUnsignedShort(BinaryNumber.swapByteOrder(byteHoldCount));
                        byte[] byteEC = new byte[6];
                        byte[] byteLevel = new byte[3];
                        ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
                        for (int index = 0; index < holdCount; ++index) {
                            this.readFully(instream, byteEC);
                            String ecNumber2 = Translator.fromEbcdic(byteEC);
                            this.readFully(instream, byteLevel);
                            String levelString = Translator.fromEbcdic(byteLevel);
                            int level = Integer.parseInt(levelString);
                            Trace.trace(TRACE_MASKF, "On hold MCL: " + ecNumber2 + "." + levelString);
                            ECStream nextEc = (ECStream)manager.getComponentByECNumber(ecNumber2);
                            if (nextEc == null) continue;
                            int retrievedLevel = nextEc.getStagedLevel();
                            int activatedLevel = nextEc.getAppliedLevel();
                            if (level <= activatedLevel || level > retrievedLevel) continue;
                            UpdateLevel nextLevel = new UpdateLevel(ecNumber2, level);
                            levelsToProcess.add(nextLevel);
                        }
                        if (levelsToProcess.size() <= 0) break block68;
                        UpdateUtilities utilities = new UpdateUtilities();
                        utilities.deleteStagedCollections(levelsToProcess);
                    }
                    Object var33_98 = null;
                    if (null == instream) break block69;
                    try {
                        instream.close();
                    }
                    catch (IOException e2) {
                        this.logAndFireError("Error on close of on hold MCLs =" + e2, (short)-3887);
                        failed = true;
                    }
                    break block69;
                    {
                        catch (FileNotFoundException fnfe) {
                            Trace.trace(TRACE_MASKD, "No MCLs are on hold");
                            Object var33_99 = null;
                            if (null == instream) break block69;
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logAndFireError("Error on close of on hold MCLs =" + e2, (short)-3887);
                                failed = true;
                            }
                            break block69;
                        }
                        catch (IOException e) {
                            this.logAndFireError("IO error =" + e, (short)-3888);
                            failed = true;
                            Object var33_100 = null;
                            if (null == instream) break block69;
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logAndFireError("Error on close of on hold MCLs =" + e2, (short)-3887);
                                failed = true;
                            }
                            break block69;
                        }
                        catch (HException e) {
                            this.logAndFireError("IO error =" + e, (short)-3886);
                            failed = true;
                            Object var33_101 = null;
                            if (null == instream) break block69;
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logAndFireError("Error on close of on hold MCLs =" + e2, (short)-3887);
                                failed = true;
                            }
                            break block69;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var33_102 = null;
                        if (null != instream) {
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logAndFireError("Error on close of on hold MCLs =" + e2, (short)-3887);
                                failed = true;
                            }
                        }
                        throw throwable;
                    }
                }
                if (function == 1) {
                    File stagingArea = new File(this.updateStagingArea);
                    UpdateManager manager = UpdateManager.getUpdateManager();
                    Iterator counterOfStreams = ranges.iterator();
                    while (counterOfStreams.hasNext() && !failed) {
                        ECStream nextEc;
                        int firstLevelToDo;
                        UpdateRange nextStream = (UpdateRange)counterOfStreams.next();
                        int lastLevelToDo = nextStream.getLastLevel();
                        if (lastLevelToDo == -1) {
                            lastLevelToDo = 10000;
                        }
                        if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecNumber = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                            firstLevelToDo = 1;
                        }
                        done = false;
                        for (int level = firstLevelToDo; !done && level <= lastLevelToDo; ++level) {
                            files = stagingArea.list(new NewMCLDataFileFilter(ecNumber, level, level));
                            if (files == null) {
                                files = new String[]{};
                            }
                            if (files.length == 0 && (files = stagingArea.list(new MCLDataFileFilter(ecNumber, level, level))).length == 0) {
                                done = true;
                            }
                            if (done) continue;
                            try {
                                MCL collection = new MCL(nextEc, level);
                                importCollections.add(collection);
                                continue;
                            }
                            catch (HException hexc) {
                                this.logAndFireError("Error creating MCL " + hexc, (short)-3898, hexc);
                                done = true;
                                failed = true;
                            }
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Files should now be available in staging area");
                    File stagingArea = new File(this.distributionStagingArea);
                    Iterator counterOfRanges = ranges.iterator();
                    while (counterOfRanges.hasNext() && !failed) {
                        String[] newFiles;
                        String[] files2;
                        UpdateRange nextRange = (UpdateRange)counterOfRanges.next();
                        String ecNumber3 = nextRange.getUpdateableComponentECNumber();
                        int firstLevel = nextRange.getFirstLevel();
                        int lastLevel = nextRange.getLastLevel();
                        int lastWrittenLevel = -1;
                        if (lastLevel == -1) {
                            lastLevel = 10000;
                        }
                        if ((files2 = stagingArea.list(new MCLDataFileFilter(ecNumber3, firstLevel, lastLevel))) != null) {
                            done = false;
                            for (int i = 0; i < files2.length && !done; ++i) {
                                Trace.trace(TRACE_MASKF, "MCL data file " + files2[i] + " has been found.");
                                int dotPosition = files2[i].indexOf(".");
                                String coverLetter = "C" + ecNumber3 + "0" + files2[i].substring(dotPosition);
                                Trace.trace(TRACE_MASKF, "coverLetter=[" + coverLetter + "].");
                                File coverLetterFile = new File(this.distributionStagingArea + coverLetter);
                                if (!coverLetterFile.exists()) continue;
                                lastWrittenLevel = Integer.parseInt(files2[i].substring(dotPosition + 1), 10);
                            }
                        }
                        if ((newFiles = stagingArea.list(new NewMCLDataFileFilter(ecNumber3, firstLevel, lastLevel))) != null) {
                            done = false;
                            for (int i = 0; i < newFiles.length && !done; ++i) {
                                Trace.trace(TRACE_MASKF, "MCL data file " + newFiles[i] + " has been found.");
                                int dotPosition1 = newFiles[i].indexOf(".");
                                int dotPosition2 = newFiles[i].indexOf(".", dotPosition1 + 1);
                                if (dotPosition2 == -1) continue;
                                String idString = newFiles[i].substring(dotPosition1 + 1, dotPosition2);
                                lastWrittenLevel = Integer.parseInt(idString, 10);
                            }
                        }
                        if (lastWrittenLevel == -1) continue;
                        UpdateRange writtenRange = new UpdateRange(ecNumber3, firstLevel, lastWrittenLevel);
                        exportCollections.add(writtenRange);
                    }
                }
            }
            if (!failed) {
                String key = "MCL0039";
                MessageText message = new MessageText(this.bundleName, key);
                UpdaterEvent event = new UpdaterEvent(this);
                event.setMessage(message);
                event.setCompletionStatus(1);
                event.setImportedUpdateCollections(importCollections);
                event.setExportedUpdateCollections(exportCollections);
                super.fireOperationCompleted(event);
            }
        }
        Trace.trace(TRACE_MASKT, "<- importRemoteUpdatesSynchronously()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRsfResult(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKT, "-> setRsfResult()");
        BaseUpdater baseUpdater = this;
        synchronized (baseUpdater) {
            this.rsfResult = result;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- setRsfResult()");
    }

    public RsfResult getRsfResult() {
        return this.rsfResult;
    }

    public void importAllUnstagedUpdatesFromMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> importAllUnstagedUpdatesFromMedia()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        boolean done = false;
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logAndFireError("Failed getting EC streams " + hexc, (short)-3903, hexc);
            String[] substText = new String[]{"Failed getting EC streams"};
            FrameworkEventText eventText = new FrameworkEventText(577, substText);
            new SystemEventLog(eventText, "MMCRETRIFAIL").log();
            new E4EventLog(eventText, "MMCRETRIFAIL").log();
            done = true;
        }
        if (!done) {
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                ECStream nextEc = (ECStream)counterOfStreams.next();
                UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                this.importUpdatesThroughLevelFromMedia(mountPoint, mediaType, levelsToProcess);
            }
        }
        Trace.trace(TRACE_MASKT, "<- importAllUnstagedUpdatesFromMedia()");
    }

    public void importUpdatesThroughLevelFromMedia(File mountPoint, int mediaType, Collection levels) {
        String where = "BaseUpdater.importUpdatesThroughLevelFromMedia()";
        Trace.trace(TRACE_MASKT, "-> " + where);
        String mediaRepositoryPath = mountPoint + XMCL_MEDIA_REPOSITORY;
        File mediaRepository = new File(mediaRepositoryPath);
        Trace.trace(TRACE_MASKF, "   " + where + " - mediaRepository -> [" + mediaRepository + "]");
        UpdateManager manager = UpdateManager.getUpdateManager();
        Iterator counterOfStreams = levels.iterator();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        String logInfo = null;
        int lowestLevelToLog = 0;
        int highestLevelToLog = 0;
        while (counterOfStreams.hasNext()) {
            String ecStream;
            ECStream nextEc;
            int firstLevelToDo;
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            if (lastLevelToDo == -1) {
                lastLevelToDo = 10000;
            }
            if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecStream = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                firstLevelToDo = 1;
            }
            highestLevelToLog = 0;
            lowestLevelToLog = 10000;
            boolean hadError = false;
            boolean done = false;
            for (int id = firstLevelToDo; !done && id <= lastLevelToDo; ++id) {
                String extension = nf.format(id);
                boolean foundDataFile = false;
                NewMCLDataFileFilter filter = new NewMCLDataFileFilter(ecStream, id, id);
                Trace.trace(TRACE_MASKD, "mediaRepository.isDirectory()" + mediaRepository.isDirectory());
                String[] newFiles = mediaRepository.list(filter);
                Trace.trace(TRACE_MASKD, "newFiles=" + newFiles);
                if (newFiles == null) {
                    newFiles = new String[]{};
                }
                if (newFiles.length > 0) {
                    foundDataFile = true;
                    String mclFileName = newFiles[0];
                    Trace.trace(TRACE_MASKF, "   " + where + " - found MCL file -> [" + mclFileName + "]");
                    String copySource = mediaRepositoryPath + mclFileName;
                    String copyTarget = this.updateStagingArea + mclFileName;
                    try {
                        UpdateUtilities.copyFile(copySource, copyTarget);
                        try {
                            new MCL(nextEc, id);
                        }
                        catch (HException hexc) {
                            this.logAndFireError("Error creating MCL " + hexc, (short)-3900, hexc);
                            hadError = true;
                            done = true;
                        }
                    }
                    catch (IOException hexc) {
                        this.logAndFireError("Error copying file " + hexc, (short)-3901, hexc);
                        hadError = true;
                        done = true;
                    }
                }
                if (!foundDataFile) {
                    done = true;
                    if (-1 != nextStream.getLevel()) {
                        String first = ecStream + "." + nf.format(firstLevelToDo);
                        String last = ecStream + "." + nf.format(lastLevelToDo);
                        String error = ecStream + "." + nf.format(id);
                        String msg = "Error retrieving specific MCL - " + first + " to " + last + " requested, " + "MCL " + error + " not found";
                        this.logAndFireError(msg, (short)-3881);
                        hadError = true;
                    }
                }
                if (hadError) {
                    String[] substText = new String[]{ecStream + "." + nf.format(id)};
                    FrameworkEventText eventText = new FrameworkEventText(577, substText);
                    new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                    new E4EventLog(eventText, "MMCRETRIFAIL").log();
                    continue;
                }
                if (!foundDataFile) continue;
                if (id < lowestLevelToLog) {
                    lowestLevelToLog = id;
                }
                if (id <= highestLevelToLog) continue;
                highestLevelToLog = id;
            }
            if (highestLevelToLog <= 0) continue;
            logInfo = null == logInfo ? ecStream + "." + nf.format(lowestLevelToLog) : logInfo + " " + ecStream + "." + nf.format(lowestLevelToLog);
            if (highestLevelToLog == lowestLevelToLog) continue;
            logInfo = logInfo + "-" + nf.format(highestLevelToLog);
        }
        if (null != logInfo) {
            short eventId = 566;
            String eventName = "MMCRET_VCART";
            if (1 == mediaType) {
                eventId = 565;
                eventName = "MMCRET_DISK";
            }
            String[] substText = new String[]{logInfo};
            FrameworkEventText eventText = new FrameworkEventText(eventId, substText);
            new SystemEventLog(eventText, eventName).log();
            new E4EventLog(eventText, eventName).log();
        }
        Trace.trace(TRACE_MASKT, "<- importUpdatesThroughLevelFromMedia()");
    }

    public boolean isMediaApplicable(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> isMediaApplicable()");
        String importDirectory = mountPoint + XMCL_MEDIA_REPOSITORY;
        Trace.trace(TRACE_MASKF, "importDirectory=[" + importDirectory + "].");
        File checkDirectory = new File(importDirectory);
        boolean applicable = checkDirectory.isDirectory();
        Trace.trace(TRACE_MASKT, "<- isMediaApplicable returns " + (applicable ? "true" : "false"));
        return applicable;
    }

    public Collection listAllUnstagedUpdateFilesOnMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> listAllUnstagedUpdateFilesOnMedia()");
        Collection updateFiles = new ArrayList();
        try {
            UpdatesOwner updatesOwner = super.getOwner();
            List streams = updatesOwner.getUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                ECStream nextEc = (ECStream)counterOfStreams.next();
                UpdateLevel nextLevel = new UpdateLevel(nextEc.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                updateFiles = this.listUpdateFilesThroughLevelOnMedia(mountPoint, mediaType, levelsToProcess);
            }
        }
        catch (HException hexc) {
            this.logError("Error getting EC streams.", (short)-3904, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- listAllUnstagedUpdateFilesOnMedia()");
        return updateFiles;
    }

    public Collection listUpdateFilesThroughLevelOnMedia(File mountPoint, int mediaType, Collection levels) {
        String where = "BaseUpdater.listUpdateFilesThroughLevelOnMedia()";
        Trace.trace(TRACE_MASKT, "-> " + where);
        ArrayList<String> updateFiles = new ArrayList<String>();
        UpdateManager manager = UpdateManager.getUpdateManager();
        Trace.trace(TRACE_MASKF, "   " + where + "levels.size() = " + levels.size());
        File mediaRepository = new File(mountPoint + XMCL_MEDIA_REPOSITORY);
        Trace.trace(TRACE_MASKF, "   " + where + " - mediaRepository -> [" + mediaRepository + "]");
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        Iterator counterOfStreams = levels.iterator();
        while (counterOfStreams.hasNext()) {
            String ecStream;
            ECStream nextEc;
            int firstLevelToDo;
            UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
            int lastLevelToDo = nextStream.getLevel();
            if (lastLevelToDo == -1) {
                lastLevelToDo = 10000;
            }
            if ((firstLevelToDo = (nextEc = (ECStream)manager.getComponentByECNumber(ecStream = nextStream.getUpdateableComponentECNumber())).getStagedLevel() + 1) == 0) {
                firstLevelToDo = 1;
            }
            Trace.trace(TRACE_MASKF, "   " + where + " - stream is " + ecStream + ", first is " + firstLevelToDo + ", last is " + lastLevelToDo);
            boolean done = false;
            for (int id = firstLevelToDo; !done && id <= lastLevelToDo; ++id) {
                String extension = nf.format(id);
                boolean foundDataFile = false;
                NewMCLDataFileFilter filter = new NewMCLDataFileFilter(ecStream, id, id);
                String[] newFiles = mediaRepository.list(filter);
                Trace.trace(TRACE_MASKD, "newFiles=" + newFiles);
                if (newFiles == null) {
                    newFiles = new String[]{};
                }
                if (newFiles.length > 0) {
                    foundDataFile = true;
                    String mclFileName = newFiles[0];
                    Trace.trace(TRACE_MASKF, "   " + where + " - found MCL file -> [" + mclFileName + "]");
                    updateFiles.add(mclFileName);
                }
                if (foundDataFile) continue;
                done = true;
                if (-1 == nextStream.getLevel()) continue;
                String first = ecStream + "." + nf.format(firstLevelToDo);
                String last = ecStream + "." + nf.format(lastLevelToDo);
                String error = ecStream + "." + nf.format(id);
                String msg = "Error retrieving specific MCL - " + first + " to " + last + " requested, " + "MCL " + error + " not found";
                Trace.trace(TRACE_MASKF, "   " + where + " - " + msg);
                throw new SpecificRequestNotPossibleException("Error retrieving specific MCL", ecStream, firstLevelToDo, lastLevelToDo, id);
            }
        }
        Trace.trace(TRACE_MASKT, "<- " + where);
        return updateFiles;
    }

    protected void logAndFireError(String errorString, short errorId) {
        HException hexc = new HException(errorString);
        this.logAndFireError(errorString, errorId, hexc);
    }

    protected void logAndFireError(String errorString, short errorId, Exception exc) {
        this.logError(errorString, errorId, exc);
        HException hexc = new HException(exc);
        UpdaterEvent event = new UpdaterEvent(this);
        event.setMessage(super.getLastMessage());
        event.setCompletionStatus(2);
        super.fireOperationCompleted(event);
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.setLastMessage(errorId);
        Trace.trace(TRACE_MASKD, "<- logError()");
    }

    public int queryAllRecalledUpdates() {
        Trace.trace(TRACE_MASKT, "-> queryAllRecalledUpdates()");
        UpdatesOwner updatesOwner = super.getOwner();
        List streams = new ArrayList();
        try {
            streams = updatesOwner.getUpdateableComponents();
        }
        catch (HException hexc) {
            this.logError("Failed getting EC streams " + hexc, (short)-3903, hexc);
        }
        ArrayList<UpdateRange> rangesToProcess = new ArrayList<UpdateRange>();
        ListIterator counterOfStreams = streams.listIterator();
        while (counterOfStreams.hasNext()) {
            ECStream nextEc = (ECStream)counterOfStreams.next();
            int firstLevelToDo = nextEc.getAppliedLevel();
            int lastLevelToDo = nextEc.getStagedLevel();
            if (firstLevelToDo == -1) {
                firstLevelToDo = 0;
            }
            if (lastLevelToDo == -1) {
                lastLevelToDo = 0;
            }
            if (lastLevelToDo < ++firstLevelToDo) continue;
            UpdateRange nextRange = new UpdateRange(nextEc.getECNumber(), firstLevelToDo, lastLevelToDo);
            rangesToProcess.add(nextRange);
        }
        if (rangesToProcess.size() > 0) {
            final ArrayList<UpdateRange> importRanges = rangesToProcess;
            int function = 3;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    BaseUpdater.this.importRemoteUpdatesSynchronously(importRanges, 3);
                }
            }, "Asynchronous importRemoteUpdates recall operation");
            thread.setDaemon(true);
            thread.start();
        }
        Trace.trace(TRACE_MASKT, "<- queryAllRecalledUpdates() - streams to process = " + rangesToProcess.size());
        return rangesToProcess.size();
    }

    public List queryStagingAreaForUpdates(String stagingAreaPath) {
        String[] newFiles;
        Trace.trace(TRACE_MASKT, "-> queryStagingAreaForUpdates()");
        ArrayList<String> tempFiles = new ArrayList<String>();
        File stagingArea = new File(stagingAreaPath);
        String[] files = stagingArea.list(new MCLDataFileFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                Trace.trace(TRACE_MASKD, "MCL data file " + files[i] + " has been found.");
                tempFiles.add(files[i]);
            }
        }
        if ((newFiles = stagingArea.list(new NewMCLDataFileFilter())) != null) {
            for (int i = 0; i < newFiles.length; ++i) {
                Trace.trace(TRACE_MASKD, "MCL data file " + newFiles[i] + " has been found.");
                tempFiles.add(newFiles[i]);
            }
        }
        Trace.trace(TRACE_MASKT, "<- queryStagingAreaForUpdates()");
        return tempFiles;
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer) throws IOException {
        this.readFully(instream, buffer, buffer.length);
    }

    protected void readFully(BufferedInputStream instream, byte[] buffer, int numberOfBytes) throws IOException {
        int allBytesRead;
        int bytesRead;
        Trace.trace(TRACE_MASKF, "-> readFully()");
        for (allBytesRead = 0; allBytesRead < numberOfBytes; allBytesRead += bytesRead) {
            bytesRead = instream.read(buffer, allBytesRead, numberOfBytes - allBytesRead);
            Trace.trace(TRACE_MASKD, "<- read() read " + bytesRead + " bytes.");
        }
        Trace.trace(TRACE_MASKF, "<- readFully() read " + allBytesRead + " bytes.");
    }

    protected void setLastMessage(short errorId) {
        Trace.trace(TRACE_MASKD, "-> setLastMessage()");
        String key = errorId == -3882 ? "MCL0021" : (errorId == 27 ? "MCFHPATCH" : "MCL1724");
        MessageText message = new MessageText(this.bundleName, key);
        super.setLastMessage(message);
        Trace.trace(TRACE_MASKD, "<- setLastMessage() - key = " + key + " - message = [" + message.toString() + "]");
    }

    static {
        try {
            XMCL_MEDIA_REPOSITORY = BaseFileControl.getFilePath("patchDir");
        }
        catch (HException e) {
            throw new IllegalArgumentException("BaseFileControl.getFilePath(\"patchDir\")");
        }
    }
}

